/*
 * Diese Datei ist Teil des GDialog Projektes:
 * "Gigaset-Erweiterung fr ProjectX"
 * 
 * Das GDialog Projekt ist freigegeben unter
 * der GNU Public Licence (GPL), deren Text sich in
 * dem Quellen-Verzeichnis befindet. Ist er dort nicht
 * mehr vorhanden, so kann er unter http://www.gnu.org/licenses/gpl.html
 * eingesehen werden.
 */
package de.m740.projectx.gigaset;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import net.sourceforge.dvb.projectx.gui.CommonGui;
import net.sourceforge.dvb.projectx.xinput.XInputDirectory;
import net.sourceforge.dvb.projectx.xinput.XInputFile;
import net.sourceforge.dvb.projectx.xinput.ftp.FtpVO;

import org.apache.commons.net.ftp.FTPClient;

import de.m740.projectx.gigaset.GPanelFTP.XInputFileComparatorAZ;


/**
 * 
 * 
 * @author arnaud
 * 
 */
public class GPanelLost extends JPanel {

    private static final long serialVersionUID = 1L;

    // --------------------------------------------------------
    class MyChangeListener implements ChangeListener {

        public void stateChanged(ChangeEvent inpE) {
            clearTable(inpE);
        }

    }

    // --------------------------------------------------
    private MyChangeListener aChangeListener = null;

    private JButton btnRefresh = new JButton(GStrings
            .getString("gdialog.lost.refresh"));

    protected JButton btnHinzufuegen = new JButton(CommonGui
            .loadIcon("addleft.gif"));

    protected JButton btnLoeschen = new JButton(GStrings
            .getString("gdialog.lost.delete"));

    private GTableModel aTableModel = new GTableModel() {
        /**
         * Von Dateien nur den letzten Teil des Namens liefern
         */
        public Object getValueAt(int inpRowIndex, int inpColumnIndex) {
            Object tmpObject = "";
            if (inpColumnIndex == 0 && inpRowIndex >= 0
                    && inpRowIndex < getRowCount()) {
                tmpObject = getListe().get(inpRowIndex);
                if (tmpObject instanceof File) {
                    return ((File) tmpObject).getName();
                }
                if (tmpObject instanceof XInputFile) {
                    return ((XInputFile) tmpObject).getName();
                }
            }
            return tmpObject;
        }
    };

    private GTable aTableAufnahmen = new GTable(aTableModel);

    private JScrollPane spAufnahmen = new JScrollPane(aTableAufnahmen);

    private GDialog aDialog = null;

    private XInputDirectory aXInputDirectory = null;

    private GFTPHandler aFTPHandler = null;

    private XInputFileComparatorAZ aXFileComparatorAZ = null;
    
    // delete per FTP allowed true/false
    protected boolean aDeleteFTP = false;

    /**
     * 
     * Constructor for this class
     * 
     * @param inpDialog
     */
    public GPanelLost(GDialog inpDialog) {
        super();
        setDialog(inpDialog);
        buildPanel();
    }

    protected void buildPanel() {
        setLayout(new BorderLayout());
        // Buttons top
        JPanel tmpPanelTop = new JPanel(new GridLayout(1, 2));
        btnRefresh.setToolTipText(GStrings.getString("gdialog.lost.tip"));
        tmpPanelTop.add(btnRefresh);
        // Buttons oben
        add(tmpPanelTop, BorderLayout.NORTH);
        // Aufnahmetabelle
        add(spAufnahmen, BorderLayout.CENTER);
        // Buttons unten
        JPanel tmpPanelBottom = new JPanel(new GridLayout(1, 2));
        btnHinzufuegen.setEnabled(false);
        btnHinzufuegen.setToolTipText(GStrings.getString("gdialog.record.add"));
        tmpPanelBottom.add(btnHinzufuegen);
        // delete button
        btnLoeschen.setToolTipText(GStrings.getString("gdialog.delete.dir.tip"));
        btnLoeschen.setEnabled(false);
        tmpPanelBottom.add(btnLoeschen);
        add(tmpPanelBottom, BorderLayout.SOUTH);
        //
        aTableAufnahmen
                .setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        //
        btnRefresh.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                // delete per FTP allowed ?
                aDeleteFTP = ((e.getModifiers() & ActionEvent.SHIFT_MASK) == ActionEvent.SHIFT_MASK);
                sucheAufnahmen();
            }
        });

        btnHinzufuegen.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                actionDone(true);
            }
        });

        btnLoeschen.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                delete();
            }
        });

        ListSelectionModel tmpSelectionModel = aTableAufnahmen
                .getSelectionModel();
        tmpSelectionModel.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    doEnabled();
                }
            }
        });

    }

    protected void clearSelection() {
        try {
            aTableAufnahmen.getSelectionModel().clearSelection();
        } catch (RuntimeException exc) {
            GConsole.setErrorMessage(exc);
        }
    }

    private void clearTable() {
        try {
            clearSelection();
            aTableModel.clear();
            aTableModel.fireTableDataChanged();
            doEnabled();
        } catch (RuntimeException exc) {
            GConsole.setErrorMessage(exc);
        }
    }

    protected void clearTable(ChangeEvent inpEvent) {
        try {
            clearTable();
        } catch (RuntimeException exc) {
            GConsole.setErrorMessage(exc);
        }
    }

    protected String shortPathOf(String inpPath) {
        if (inpPath == null) {
            return "";
        }
        char tmpC = File.separatorChar;
        int x1 = inpPath.indexOf(tmpC);
        String tmpString = "";
        if (x1 > 0) {
            int len = inpPath.length();
            tmpString += inpPath.substring(0, x1 + 1);
            inpPath = (len - 1 == x1) ? "" : inpPath.substring(x1 + 1);
        }
        int x2 = inpPath.lastIndexOf(File.separatorChar);
        tmpString += (x2 == x1 || x2 < 0) ? inpPath : "..."
                + inpPath.substring(x2);
        return tmpString;
    }

    protected GDialog getDialog() {
        return aDialog;
    }

    protected void setDialog(GDialog inpDialog) {
        aDialog = inpDialog;
    }

    protected GTable getTableAufnahmen() {
        return aTableAufnahmen;
    }

    /**
     * 
     */
    protected void actionDone(boolean inpOK) {
        if (inpOK) {
            ActionEvent tmpActionEvent = new ActionEvent(this, 2, "apply");
            getDialog().getActionListener().actionPerformed(tmpActionEvent);
        }
    }

    protected void doEnabled() {
        try {
            int index = getTableAufnahmen().getSelectedRow();
            boolean enable = (index >= 0);
            // nicht enabeln wenn gerade gesucht wird
            enable &= btnRefresh.isEnabled();
            btnHinzufuegen.setEnabled(enable);
            // Loeschen nicht bei FTP auer wenn ausdruecklich erlaubt
            enable &= aDeleteFTP || (getXInputDirectory() == null); 
            btnLoeschen.setEnabled(enable);
        } catch (RuntimeException exc) {
            GConsole.setErrorMessage(exc);
        }
    }

    public void addDirectory(File inpDir) {
        try {
            int i = aTableModel.getRowCount();
            aTableModel.addRow(inpDir);
            aTableModel.fireTableRowsInserted(i, i);
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    public ChangeListener getChangeListener() {
        if (aChangeListener == null) {
            aChangeListener = new MyChangeListener();
        }
        return aChangeListener;
    }

    /**
     * 
     * @return List of File or XInputDiretory (fmpg-directories)
     */
    protected List getUsedRecDirectories() {
        List tmpList = null;
        try {
            tmpList = getDialog().getUsedRecDirectories();
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpList;
    }

    /**
     * 
     */
    public void sucheAufnahmen() {
        btnRefresh.setEnabled(false);
        Runnable tmpRunnable = new Runnable() {
            public void run() {
                try {
                    sucheAufnahmen2();
                } catch (Exception exc) {
                    GConsole.setErrorMessage(exc);
                }
            }

        };
        try {
            if (EventQueue.isDispatchThread()) {
                new Thread(tmpRunnable).start();
            } else {
                EventQueue.invokeLater(tmpRunnable);//
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    /**
     * 
     * @param inpUsedDirList
     */
    protected void sucheAufnahmen2() {
        try {
            clearTable();
            setXInputDirectory(null);
            // 
            List tmpList = new ArrayList();
            Object tmpObj = getDialog().getLostRecDirectories(tmpList);
            // if (tmpObj == null) {
            // return;
            // }
            if (tmpObj instanceof XInputDirectory) {
                setXInputDirectory((XInputDirectory) tmpObj);
                btnLoeschen.setText(GStrings.getString("gdialog.lost.delete"));
            } else {
                btnLoeschen.setText(GStrings.getString("gdialog.lost.detail"));
            }
            //
            int anzd = (tmpList == null) ? 0 : tmpList.size();
            for (int i = 0; i < anzd; i++) {
                tmpObj = tmpList.get(i);
                aTableModel.addRow(tmpObj);
                aTableModel.fireTableRowsInserted(i, i);
            } // for i
            if (aTableModel.getRowCount() == 0) {
                File tmpFile = new File("--- no losts found :-) ---");
                aTableModel.addRow(tmpFile);
                aTableModel.fireTableRowsInserted(0, 0);
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        } finally {
            btnRefresh.setEnabled(true);
        }
    }

    /**
     * 
     * @param inpObjects
     * @param inpRows
     * @return
     */
    private boolean[] deleteLocal(Object[] inpObjects, int[] inpRows) {
        boolean[] tmpOKs = null;
        try {
            if (inpObjects == null || inpObjects.length == 0) {
                return null;
            }
            File[] tmpDirs = new File[inpObjects.length];
            String tmpTitel = GStrings.getString("gdialog.delete.dir");
            String[] tmpPathes = new String[tmpDirs.length];
            for (int i = 0; i < tmpPathes.length; i++) {
                tmpDirs[i] = (File) inpObjects[i];
                File tmpDir = tmpDirs[i];
                if (!tmpDir.isDirectory()) {
                    continue;
                }
                String tmpDirPath = tmpDir.getAbsolutePath();
                tmpDirPath = tmpDirPath.replace('\\', '/');
                tmpPathes[i] = tmpDirPath;
            } // for i
            JFileChooser tmpChooser = new JFileChooser(tmpDirs[0]);
            tmpChooser.setApproveButtonText(tmpTitel);
            // tmpChooser.setApproveButtonToolTipText(tmpTitel);
            tmpChooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
            int tmpI = tmpChooser.showDialog(this, tmpTitel);
            if (tmpI != JFileChooser.APPROVE_OPTION) {
                return null;
            }
            Toolkit.getDefaultToolkit().beep();
            String tmpWarning = GStrings.getString("gdialog.delete.warning");
            StringBuffer tmpBuffer = new StringBuffer();
            for (int i = 0; i < tmpPathes.length; i++) {
                tmpBuffer.append(tmpPathes[i]);
                tmpBuffer.append("<br>");
            } // for i
            tmpWarning = tmpWarning.replaceAll("%dir%", tmpBuffer.toString());
            if (JOptionPane.showConfirmDialog(this, tmpWarning, tmpTitel,
                    JOptionPane.WARNING_MESSAGE) != JOptionPane.OK_OPTION) {
                return null;
            }
            //
            // delete directories (due to table from bottom to top!)
            tmpOKs = new boolean[tmpDirs.length];
            for (int j = tmpDirs.length - 1; j >= 0; j--) {
                File tmpDir = tmpDirs[j];
                File[] tmpFiles = tmpDir.listFiles();
                int anz = (tmpFiles == null) ? 0 : tmpFiles.length;
                // Einzeldateien lschen
                boolean ok = true;
                for (int i = 0; ok && i < anz; i++) {
                    File tmpFile = tmpFiles[i];
                    ok = tmpFile.delete();
                } // for i
                String tmpMsg = tmpDir.getAbsolutePath();
                if (ok) {
                    ok = tmpDir.delete();
                    if (ok) {
                        int row = inpRows[j];
                        aTableModel.removeRow(row);
                        aTableModel.fireTableRowsDeleted(row, row);
                    }
                }
                tmpOKs[j] = ok;
                GConsole.setInfo(tmpMsg + (ok ? " " : " not ") + "deleted");
            } // for j
            //
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpOKs; // error
    }

    /**
     * 
     * @param inpObjects
     * @param inpRows
     * @return
     */
    private boolean[] deleteFTP(Object[] inpObjects, int[] inpRows) {
        boolean[] tmpBs = null;
        try {
            if (inpObjects == null || inpObjects.length == 0) {
                return null;
            }
            GFTPHandler tmpHandler = getFTPHandler();
            FtpVO tmpVO = tmpHandler.makeVOFrom(getXInputDirectory());
            XInputFile[] inpFiles = new XInputFile[inpObjects.length];
            XInputDirectory[] tmpDirs = new XInputDirectory[inpFiles.length];
            XInputFile[][] tmpFiles = new XInputFile[inpFiles.length][];
            StringBuffer tmpBuffer = new StringBuffer();
            for (int i = 0; i < inpFiles.length; i++) {
                inpFiles[i] = (XInputFile) inpObjects[i];
                XInputFile tmpFile = inpFiles[i];
                XInputDirectory tmpDir = tmpHandler.makeDirectoryFrom(tmpFile,
                        tmpVO);
                tmpDirs[i] = tmpDir;
                tmpFiles[i] = tmpDir.getFiles();
                tmpBuffer.append(tmpDir.getDirectory());
                tmpBuffer.append("<br>");
            } // for i
            //
            //
            int anz = (tmpFiles == null) ? 0 : tmpFiles.length;
            Toolkit.getDefaultToolkit().beep();
            String tmpWarning = GStrings.getString("gdialog.delete.warning");
            tmpWarning = tmpWarning.replaceAll("%dir%", tmpBuffer.toString());
            String tmpTitel = GStrings.getString("gdialog.delete.dir");
            if (JOptionPane.showConfirmDialog(this, tmpWarning, tmpTitel,
                    JOptionPane.WARNING_MESSAGE) != JOptionPane.OK_OPTION) {
                return null;
            }
            //
            FTPClient tmpClient = tmpHandler.openClient(tmpVO);
            tmpBs = new boolean[anz];
            // delete directories (due to table from bottom to top!)
            for (int i = anz - 1; i >= 0; i--) {
                String tmpWD = tmpDirs[i].getDirectory();
                boolean ok = tmpClient.changeWorkingDirectory(tmpWD);
                // Einzeldateien lschen
                for (int j = 0; ok && j < tmpFiles[i].length; j++) {
                    XInputFile tmpFile = tmpFiles[i][j];
                    String tmpFN = tmpFile.getName();
                    if (!".".equals(tmpFN) && !"..".equals(tmpFN)) {
                        ok = tmpClient.deleteFile(tmpFN);
                    }
                } // for j
                XInputDirectory tmpDir = tmpDirs[i];
                String tmpFN = tmpDir.getDirectory();
                if (ok) {
                    ok = tmpClient.removeDirectory(tmpFN);
                    if (ok) {
                        int row = inpRows[i];
                        aTableModel.removeRow(row);
                        aTableModel.fireTableRowsDeleted(row, row);
                    }
                }
                tmpBs[i] = ok;
                GConsole.setInfo(tmpFN + (ok ? " " : " not ") + "deleted");
            } // for i
            //
            //
            tmpHandler.closeClient(tmpClient);
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpBs;
    }

    /**
     * 
     * 
     */
    protected void delete() {
        btnLoeschen.setEnabled(false);
        try {
            GTable tmpTable = getTableAufnahmen();
            int[] tmpRows = tmpTable.getSelectedRows();
            if (tmpRows == null || tmpRows.length == 0) {
                return;
            }
            Object[] tmpObjects = new Object[tmpRows.length];
            for (int i = 0; i < tmpRows.length; i++) {
                tmpObjects[i] = ((GTableModel) tmpTable.getModel())
                        .getObjectAtRow(tmpRows[i]);
            } // for i
            boolean[] tmpOKs = null;
            if (tmpObjects[0] instanceof File) {
                tmpOKs = deleteLocal(tmpObjects, tmpRows);
            } else if (tmpObjects[0] instanceof XInputFile) {
                tmpOKs = deleteFTP(tmpObjects, tmpRows);
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    /**
     * 
     * @param inpObjects
     * @param inpRows
     * @return List of XInputFile
     */
    private List copyLocal(Object[] inpObjects, int[] inpRows) {
        List tmpList = null;
        try {
            if (inpObjects == null || inpObjects.length == 0) {
                return null;
            }
            int anzd = inpObjects.length;
            File[] tmpDirs = new File[anzd];
            for (int i = 0; i < anzd; i++) {
                File tmpFile = (File) inpObjects[i];
                if (tmpFile.isDirectory()) {
                    tmpDirs[i] = tmpFile;
                } else {
                    tmpDirs[i] = null;
                }
            } // for i
            //
            for (int i = 0; i < tmpDirs.length; i++) {
                File tmpDir = tmpDirs[i];
                if (tmpDir == null) {
                    continue;
                }
                File[] tmpFiles = tmpDir.listFiles(new FilenameFilter() {
                    public boolean accept(File f, String s) {
                        return s.toLowerCase().endsWith(GAufnahmeIF.EXTENSION);
                    }
                });
                int anzf = (tmpFiles == null) ? 0 : tmpFiles.length;
                if (anzf > 1) {
                    Arrays.sort(tmpFiles);
                }
                for (int j = 0; j < anzf; j++) {
                    File tmpFile = tmpFiles[j];
                    XInputFile tmpXFile = new XInputFile(tmpFile);
                    if (tmpList == null) {
                        tmpList = new ArrayList();
                    }
                    tmpList.add(tmpXFile);
                } // for j
                GConsole.setMessage("Get " + anzf + " lost "
                        + GAufnahmeIF.EXTENSION + "-files from "
                        + tmpDirs[i].getName());
            } // for i
            //
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpList;
    }

    /**
     * 
     * @param inpObjects
     * @param inpRows
     * @return
     */
    private List copyFTP(Object[] inpObjects, int[] inpRows) {
        List tmpList = null;
        try {
            if (inpObjects == null || inpObjects.length == 0) {
                return null;
            }
            GFTPHandler tmpHandler = getFTPHandler();
            FtpVO tmpVO = tmpHandler.makeVOFrom(getXInputDirectory());
            XInputFile[] inpFiles = new XInputFile[inpObjects.length];
            XInputDirectory[] tmpDirs = new XInputDirectory[inpFiles.length];
            XInputFile[][] tmpFiles = new XInputFile[inpFiles.length][];
            for (int i = 0; i < inpFiles.length; i++) {
                inpFiles[i] = (XInputFile) inpObjects[i];
                XInputFile tmpFile = inpFiles[i];
                XInputDirectory tmpDir = tmpHandler.makeDirectoryFrom(tmpFile,
                        tmpVO);
                tmpDirs[i] = tmpDir;
                XInputFile[] tmpFiles2 = tmpDir.getFiles();
                tmpFiles[i] = tmpFiles2;
            } // for i
            //
            int anz = (tmpFiles == null) ? 0 : tmpFiles.length;
            //
            for (int i = 0; i < anz; i++) {
                XInputFile[] tmpFilesJ = tmpFiles[i];
                int anzf = (tmpFilesJ == null) ? 0 : tmpFilesJ.length;
                List tmpList2 = null;
                for (int j = 0; j < anzf; j++) {
                    XInputFile tmpFile = tmpFilesJ[j];
                    String tmpFN = tmpFile.getName();
                    if (tmpFN.toLowerCase().endsWith(GAufnahmeIF.EXTENSION)) {
                        if (tmpList2 == null) {
                            tmpList2 = new ArrayList();
                        }
                        tmpList2.add(tmpFile);
                    }
                } // for j
                anzf = 0;
                if (tmpList2 != null) {
                    anzf = tmpList2.size();
                    if (anzf > 1) {
                        Collections.sort(tmpList2, getXFileComparatorAZ());
                    }
                    if (tmpList == null) {
                        tmpList = tmpList2;
                    } else {
                        tmpList.addAll(tmpList2);
                    }
                    tmpList2 = null;
                }
                GConsole.setMessage("Get " + anzf + " lost "
                        + GAufnahmeIF.EXTENSION + "-files from "
                        + tmpDirs[i].getDirectory());
            } // for i
            //
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpList;
    }

    /**
     * 
     * 
     */
    public List getSelectedLostMPGs() {
        btnLoeschen.setEnabled(false);
        List tmpList = null;
        try {
            GTable tmpTable = getTableAufnahmen();
            int[] tmpRows = tmpTable.getSelectedRows();
            if (tmpRows == null || tmpRows.length == 0) {
                return null;
            }
            Object[] tmpObjects = new Object[tmpRows.length];
            for (int i = 0; i < tmpRows.length; i++) {
                tmpObjects[i] = ((GTableModel) tmpTable.getModel())
                        .getObjectAtRow(tmpRows[i]);
            } // for i
            if (tmpObjects[0] instanceof File) {
                tmpList = copyLocal(tmpObjects, tmpRows);
            } else if (tmpObjects[0] instanceof XInputFile) {
                tmpList = copyFTP(tmpObjects, tmpRows);
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpList;
    }

    private XInputDirectory getXInputDirectory() {
        return aXInputDirectory;
    }

    private void setXInputDirectory(XInputDirectory inpInputDirectory) {
        aXInputDirectory = inpInputDirectory;
    }

    /**
     * @return fTPHandler
     */
    protected GFTPHandler getFTPHandler() {
        if (aFTPHandler == null) {
            aFTPHandler = new GFTPHandler();
        }
        return aFTPHandler;
    }

    protected XInputFileComparatorAZ getXFileComparatorAZ() {
        if (aXFileComparatorAZ == null) {
            aXFileComparatorAZ = new XInputFileComparatorAZ();
        }
        return aXFileComparatorAZ;
    }

}
